package gov.va.med.mhv.healthwise.portlet;

import org.apache.beehive.netui.pageflow.PageFlowController;
import org.apache.beehive.netui.pageflow.annotations.Jpf;
import org.apache.beehive.netui.pageflow.Forward;

@Jpf.Controller()
public class HealthwiseController extends PageFlowController {
  private static final long serialVersionUID = -2004692363L;
  private static final String defaultPath;
  private static final String newLink;
  
  static {
    java.util.Properties PROPS = org.tigris.atlas.config.ConfigurationManager.getConfiguration("/healthwise.properties");
    defaultPath = PROPS.getProperty("healthwise.default.location", "http://www.veteranshealthlibrary.org/");
    newLink = PROPS.getProperty("healthwise.new.link","http://www.veteranshealthlibrary.org/");
    
  }

  @Jpf.Action(forwards = {
      @Jpf.Forward(name = "success", path = "Healthwise.jsp")
  })
  public Forward begin() {
	  try{
		  //bug#3904 need to redirect the url to healthwise site.
	 	    this.getResponse().sendRedirect(newLink);
	 	    	
		  }catch(Exception e){
	 	  	System.out.println("Redirect URL failed");
	 	  	
		  }
    
   return null;
	 
  }
}